/*On importe le fichier de donnees*/
PROC IMPORT OUT= WORK.depenses 
            DATAFILE= "D:\OneDrive\Etude\1- STID\SAE\7- Analyse multivarie d'un reporting\data\depenses.xls" 
            DBMS=EXCEL REPLACE;
     RANGE="FOODS$"; 
     GETNAMES=YES;
     MIXED=NO;
     SCANTEXT=YES;
     USEDATE=YES;
     SCANTIME=YES;
RUN;

/*Graphique des individus*/
/*a. Table d'annotations*/
DATA tableAnnotations;
SET acp_par;
LENGTH COLOR $20.;
x=prin1;
y=prin2;
xsys="2";
ysys="2";
L1 = 7.71729735;
L2 = 2.62319881;
/*x ou prin1 c'est la meme chose x=pin1 idem pour y et prin2*/
if abs(x) > sqrt(L1) then color="red";
if abs(y) > sqrt(L2) then color="blue";
if (abs(x) > sqrt(L1) and abs(y) > sqrt(L2)) then color="green";
text=marque;
RUN;

GOPTIONS RESET=all;
TITLE "Graphique des individus axe2*axe1";

PROC GPLOT DATA = toto;
PLOT y*x / ANNOTATE=toto frame href=0 vref=0;
/*Frame = faire un cadre href=vref=0, les axes se coupent en (0, 0)*/
symbol1 v=none i=none;
RUN;

/*Graphique des variables*/
/*Les coordonnees des variables sont leurs correlations avec les composantes principales (cf. cours dernier paragraphe)
On va donc calculer ces correlations (proc corr). Comme on n'a pas besoin de les voir on met un noprint mais on les recupere dans la table corr*/

PROC CORR DATA = acp_par OUT = corr NOPRINT;
VAR prin1 prin2;
WITH the -- yaourt;
RUN;

Exemple :
DATA toto2;
SET corr;
WHERE _type_ = "CORR";
x=prin1;
y=prin2;
xsys="2";
ysys="2";
text=_name_;
RUN;

TITLE "Graphique des variables axe2*axe1";
PROC GPLOT;
PLOT y*x / ANNOTATE=toto2 frame href=0 vref=0
			haxis=-1 to 1 by 0.5
			vaxis=-1 to 1 by 0.5;
RUN;

/*On cree la table avec les valeurs propres...*/
ODS TRACE ON;
	PROC PRINCOMP DATA = work.depenses OUT=acp_par n=5;
	VAR the -- yaourt;
	ODS OUTPUT Eigenvalues = valeursPropres;
	ODS OUTPUT Eigenvectors = vecteursPropres;
	RUN;
ODS TRACE OFF;
QUIT;

/*On renomme les colonnes*/
DATA valeursPropres ;
SET valeursPropres ;
RENAME Number = Numero_de_axe;
RENAME Eigenvalue = Valeurs_propres;
RENAME Cumulative = Cumul;
run ;

/*On supprime les colonnes inutiles*/
DATA valeursPropres;
SET valeursPropres(drop=Difference);
RUN;

DATA vecteursPropres;
SET vecteursPropres(drop=Label);
RUN;

/*On ecrit le rapport RTF*/
ODS RTF FILE = "D:\OneDrive\Etude\1- STID\SAE\7- Analyse multivarie d'un reporting\compteRenduSortie.rtf" startpage=no;

	options nodate nonumber;

	TITLE color ="red" font="Calibri" height=20pt "Analyse de l'ACP";

	ods rtf text="---- Nombres d'axes  retenir ----";

	/*On affiche la table des valeurs propres*/
	PROC PRINT DATA=work.valeursPropres NOOBS;
	RUN;

	ods rtf text="---- Caractrisation des axes ----";

	/*On affiche la table des vecteurs propres*/
	PROC PRINT DATA=work.vecteursPropres NOOBS;
	RUN;

data acp;
length color $30.;
set notesX;
x=prin&i;
y=prin&j;
xsys='2';
ysys='2';
text=&id;

title "Reprsentation des individus axe&i * axe&j";
proc gplot;
plot y*x /annotate=acp frame href=0 vref=0;
symbol1 v=none;
run;


data variable;
length color $30.;
set corr;
where _TYPE_='CORR';
x=prin&i;
y=prin&j;
xsys='2';
ysys='2';
xmin=-1;
xmax=1;
ymax=1;
ymin=-1;
text=_name_;

title "Reprsentation des variables axe&i * axe&j";
proc gplot;
plot y*x /annotate=variable frame href=0 vref=0
haxis=-1 to 1 by 0.5
vaxis=-1 to 1 by 0.5;
symbol1 v=none;
run;

ODS RTF CLOSE;
